<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Slick CSS -->
    <link rel="stylesheet" type="text/css"
        href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css" />

    <!-- Slick Theme CSS (optional) -->
    <link rel="stylesheet" type="text/css"
        href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css" />


</head>

<style>
.categories-list-row {
    display: flex !important;
    justify-content: center !important;
    align-items: center;
}

.slick-next {
    right: 10px !important;
}

.slick-prev {
    left: 10px !important;
    z-index: 10;
}

.slick-next:before,
.slick-prev:before {
    font-family: slick;
    font-size: 20px;
    line-height: 1;
    opacity: .75;
   color: #b62323 !important;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}

.slick-next:before,
.slick-prev:before {
    font-family: slick;
    font-size: 20px;
    line-height: 1;
    opacity: .75;
    color: #b62323 !important;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}

slick-prev:before,
.slick-prev:before {
    font-family: slick;
    font-size: 20px;
    line-height: 1;
    opacity: .75;
    color: #000000 !important`;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}



.gtco-testimonials {
    position: relative;
    margin-top: 30px;

    h2 {
        font-size: 30px;
        text-align: center;
        color: #333333;
        margin-bottom: 50px;
    }

    .owl-stage-outer {
        padding: 30px 0;
    }

    .owl-nav {
        display: none;
    }

    .owl-dots {
        text-align: center;

        span {
            position: relative;
            height: 10px;
            width: 10px;
            border-radius: 50%;
            display: block;
            background: #fff;
            margin: 0 5px;
        }

        .active {
            box-shadow: none;

            span {
                background: #01b0f8;
                box-shadow: none;
                height: 12px;
                width: 12px;
                margin-bottom: -1px;
            }
        }
    }

    .card {
        background: #fff;
        margin: 0 20px;
        padding: 0 10px;
        border-radius: 20px;
        border: 0;



        h5 {
            font-size: 21px;
            line-height: 1.3;

            span {
                font-size: 18px;
                color: #666666;
            }
        }

        p {
            font-size: 18px;
            color: #555;
            padding-bottom: 15px;
        }
    }

    .active {
        opacity: 0.5;
        transition: all 0.3s;
    }

    .center {
        opacity: 1;

        h5 {
            font-size: 24px;

            span {
                font-size: 20px;
            }
        }

        .card-img-top {
            max-width: 100%;
            height: 120px;
            width: 120px;
        }
    }
}

@media (max-width: 767px) {
    .gtco-testimonials {
        margin-top: 20px;
    }
}

.owl-carousel {
    .owl-nav button {

        &.owl-next,
        &.owl-prev {
            outline: 0;
        }
    }

    button.owl-dot {
        outline: 0;
    }
}
.whatsapp-icon-main {
    position: fixed;
    z-index: 2000;
    top: 87%;
    right: 30px;
}
.btn-whatsapp-pulse-border::before {
    content: "";
    position: absolute;
    border-radius: 50%;
    padding: 25px;
    border: 5px solid #25d366;
    opacity: 0.75;
    animation-name: pulse-border;
    animation-duration: 1.5s;
    animation-timing-function: ease-out;
    animation-iteration-count: infinite;
}
.btn-whatsapp-pulse-border {
    bottom: 120px;
    right: 20px;
    text-decoration: none;
    color: white;
    animation-play-state: paused;
}
.btn-whatsapp-pulse {
       background: #25d366;
    color: white;
    position: fixed;
    bottom: 65px;
    right: 8px;
    font-size: 25px;
    display: flex;
    justify-content: center;
    align-items: center;
    width: 0;
    height: 0;
    padding: 28px;
    text-decoration: none;
    border-radius: 50%;
    animation-name: pulse;
    animation-duration: 1.5s;
    animation-timing-function: ease-out;
    animation-iteration-count: infinite;
}


</style>

<body>

    <!-- Header -->
    <?php
  include("header.php");
  include("./admin/includes/config.php");
  ?>

    <!-- End Header -->

    <main id="main">

        <!--Banner-->
        <div class="slick-slider">
            <div>
                <img class="img-fluid" src="./assets/images/banner/banner-1.jpg" alt="Slider Image 1" />
            </div>
            <div>
                <img class="img-fluid" src="./assets/images/banner/banner-2.jpg" alt="Slider Image 2" />
            </div>
            <div>
                <img class="img-fluid" src="./assets/images/banner/banner-3.jpg" alt="Slider Image 3" />
            </div>
            <div>
                <img class="img-fluid" src="./assets/images/banner/banner-4.jpg" alt="Slider Image 3" />
            </div>
        </div>
<div class="whatsapp-icon-main">
          <a href=" https://wa.me/+919150050015" class="btn-whatsapp-pulse btn-whatsapp-pulse-border">
            <i class="bi bi-whatsapp"></i>
          </a>
        </div>




        <!-- Shop By Categories -->

        <!-- normal-section Shop By Categories -->
        <section class="normal-section d-none d-lg-block">
            <div class="container">
                <div class="section-heading">
                    <div class="d-flex justify-content-center align-items-center">
                        <span> <img class="heading-icon" src="./assets/images/icon/heading-icon.png" alt="" srcset="">
                        </span>
                        <h3> Top Categories</h3>
                    </div>
                </div>
                <div class="row mb-4">
                    <div class="col-md-3 d-flex justify-content-center">
                        <div class="image-container">
                            <img class="img-fluid " src="./assets/images/categories/1.png" alt="">
                            <div class="overlay">
                                <div class="text">Camphor </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 d-flex justify-content-center">
                        <div class="image-container">
                            <img class="img-fluid " src="./assets/images/categories/2.png" alt="">
                            <div class="overlay">
                                <div class="text">Kumkumam</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 d-flex justify-content-center">
                        <div class="image-container">
                            <img class="img-fluid " src="./assets/images/categories/3.png" alt="">
                            <div class="overlay">
                                <div class="text">Fack Pack Powder</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 d-flex justify-content-center">
                        <div class="image-container">
                            <img class="img-fluid " src="./assets/images/categories/4.png" alt="">
                            <div class="overlay">
                                <div class="text">Rose Water</div>
                            </div>
                        </div>
                    </div>

                </div>


            </div>
        </section>


        <!-- Carosuel slider -->
        <!-- Carousel for screen sizes below 768px -->
        <section class="d-lg-none">
            <div class="container-fluid">
                <div class="unique-slick-slider">
                    <!-- Categories-list-main-1 -->
                    <div class="categories-list-row">
                        <!-- Categories-list-1 -->
                        <div class="categories-list-main">
                            <div class="categories-list-img">
                                <img class="img-fluid" src="./assets/images/categories/1.png" alt="Camphor">
                            </div>
                             <div class="categories-list-info">
                                <a href="#">Camphor</a>
                            </div>
                            
                        </div>
                       
                        <!-- End Categories-list -->
                    </div>
                    <!-- Categories-list-main-1 -->
                    <div class="categories-list-row">
                        <!-- Categories-list-1 -->
                        <div class="categories-list-main">
                            <div class="categories-list-img">
                                <img class="img-fluid" src="./assets/images/categories/2.png" alt="Kumkumam">
                            </div>
                            <div class="categories-list-info">
                                <a href="#">Kumkumam</a>
                            </div>
                        </div>
                        <!-- End Categories-list -->
                    </div>
                    <!-- Categories-list-main-1 -->
                    <div class="categories-list-row">
                        <!-- Categories-list-1 -->
                        <div class="categories-list-main">
                            <div class="categories-list-img">
                                <img class="img-fluid" src="./assets/images/categories/3.png" alt="Face Pack Powder">
                            </div>
                            <div class="categories-list-info">
                                <a href="#">Face Pack Powder</a>
                            </div>
                        </div>
                        <!-- End Categories-list -->
                    </div>
                    <div class="categories-list-row">
                        <!-- Categories-list-1 -->
                        <div class="categories-list-main">
                            <div class="categories-list-img">
                                <img class="img-fluid" src="./assets/images/categories/4.png" alt="Rose Water">
                            </div>
                            <div class="categories-list-info">
                                <a href="#">Rose Water</a>
                            </div>
                        </div>
                        <!-- End Categories-list -->
                    </div>
                    <!-- End Categories-list-main -->
                </div>
            </div>
        </section>






        <!-- Best Sellers -->
        <section>
            <div class="container">
                <div class="section-heading">
                    <div class="d-flex justify-content-center align-items-center">
                        <span> <img class="heading-icon" src="./assets/images/icon/heading-icon.png" alt="" srcset="">
                        </span>
                        <h3> Best Sellers</h3>
                    </div>
                </div>
                <div class="row">
                    <!-- Best Seller -1 -->
                    <?php $bestseller = mysqli_query($con, "SELECT * FROM product ORDER BY product_name ASC LIMIT 6;"); ?>
                    <div class="owl-carousel owl-carousel-best-sellar owl-theme">
                        <?php foreach ($bestseller as $value) { ?>
                        <div class="item">
                            <div class="">
                                <div class="product-card">
                                    <div class="product-tumb">
                                        <div class="image-container">
                                            <img class="img-fluid default-img"
                                                src="./admin/<?php echo $value['image_default']; ?>" alt="">
                                            <img class="img-fluid hover-img"
                                                src="./admin/<?php echo $value['image_hover']; ?>" alt="">
                                        </div>
                                    </div>
                                    <div class="product-details">
                                        <div class="d-flex justify-content-between">
                                            <span class="product-catagory"><?php echo $value['product_name']; ?></span>
                                            <!-- <a href="#"><i class="fa fa-heart"></i></a> -->
                                        </div>
                                        <p class="text-limit"><a href="#"><?php echo $value['description']; ?></a></p>
                                        <div class="product-bottom-details">
                                            <div class="product-price"><?php echo $value['price']; ?></div>
                                        </div>
                                        <div class="d-flex justify-content-center align-items-center mt-3">
                                            <a class="view-detail"
                                                href="product-detail.php?id=<?= $value['id']; ?>">View Details</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php } ?>

                    </div>
                </div>
        </section>

        <!-- New Araivals -->

        <div>
            <div class="container">
                <div class="section-heading">
                    <div class="d-flex justify-content-center align-items-center">
                        <span> <img class="heading-icon" src="./assets/images/icon/heading-icon.png" alt="" srcset="">
                        </span>
                        <h3> New Arrivals</h3>
                    </div>
                </div>
                <div class="row">
                    <!-- New Araivals -1 -->
                    <?php $bestseller = mysqli_query($con, "SELECT * FROM product ORDER BY product_name DESC LIMIT 6;"); ?>
                    <div class="owl-carousel owl-carousel-best-sellar owl-theme">
                        <?php foreach ($bestseller as $value) { ?>
                        <div class="item">
                            <div class="">
                                <div class="product-card">
                                    <div class="product-tumb">
                                        <div class="image-container">
                                            <img class="img-fluid default-img"
                                                src="./admin/<?php echo $value['image_default']; ?>" alt="">
                                            <img class="img-fluid hover-img"
                                                src="./admin/<?php echo $value['image_hover']; ?>" alt="">
                                        </div>
                                    </div>
                                    <div class="product-details">
                                        <div class="d-flex justify-content-between">
                                            <span class="product-catagory"><?php echo $value['product_name']; ?></span>
                                            <!-- <a href="#"><i class="fa fa-heart"></i></a> -->
                                        </div>
                                        <p class="text-limit"><a href="#"><?php echo $value['description']; ?></a></p>
                                        <div class="product-bottom-details">
                                            <div class="product-price"><?php echo $value['price']; ?></div>
                                        </div>
                                        <div class="d-flex justify-content-center align-items-center mt-3">
                                            <a class="view-detail"
                                                href="product-detail.php?id=<?= $value['id']; ?>">View Details</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php } ?>

                    </div>
                </div>
            </div>
        </div>

        <!-- Information Section -->
        <section>
            <div class="container-fluid information-section">
                <div class="row">
                    <!-- empty -->
                    <div class="col-lg-3">

                    </div>

                    <div class="col-lg-6 text-center information-section-info-main">
                        <div class="information-section-info">
                            <div>
                                <h2>Welcome to Bagyalakshmi - Your Trusted Source for Devotion Items</h2>
                                <p>At Bagyalakshmi, we are dedicated to providing high-quality devotion items that bring
                                    purity and positivity to your spiritual practices. Whether you're seeking the finest
                                    camphor for your daily rituals or authentic kumkum to enhance your pooja ceremonies,
                                    Bagyalakshmi is your one-stop destination.</p>
                                <div>
                                    <a class="view-detail" href="">Enquiry Now</a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- empty -->
                    <div class="col-lg-3"></div>


                </div>

            </div>
        </section>

        <!-- Additional section -->
        <section>
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 ">
                        <div class="additional-section-main">
                            <img class="img-fluid " src="./assets/images/additional-section/additional-section-1.png"
                                alt="">
                        </div>
                    </div>
                    <div class="col-lg-6 d-flex">
                        <div class="d-flex justify-content-center align-items-center additional-section-main-info">
                            <div>
                                <h3  class="text-left" >Join the Bagyalakshmi Family</h3>
                                <div class="text-left"  >
                                     <p>Enhance your spiritual journey with devotion items that reflect the essence of your
                                    beliefs. Bagyalakshmi is more than just a store; it's a place where tradition meets
                                    quality, and devotion finds its true expression.</p>
                                <p>Enhance your spiritual journey with devotion items that reflect the essence of your
                                    beliefs. Bagyalakshmi is more than just a store; it's a place where tradition meets
                                    quality, and devotion finds its true expression.</p>
                                <p>Enhance your spiritual journey with devotion items that reflect the essence of your
                                    beliefs. Bagyalakshmi is more than just a store; it's a place where tradition meets
                                    quality, and devotion finds its true expression.</p> 
                                    
                                </div>
                              
                                <div>
                                    <a href="" class="view-detail">Explore</a>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-lg-6 d-flex">
                        <div class="d-flex justify-content-center align-items-center additional-section-main-info">
                            <div  >
                                <h3 class="text-center">Explore Our Range</h3>
                                <div class="text-left">
                                     <p>Browse through our wide range of devotion items and discover the perfect products to
                                    enrich your rituals. Bagyalakshmi is here to support your spiritual needs with care
                                    and dedication.</p>
                                <p>Browse through our wide range of devotion items and discover the perfect products to
                                    enrich your rituals. Bagyalakshmi is here to support your spiritual needs with care
                                    and dedication.</p>
                                <p>Browse through our wide range of devotion items and discover the perfect products to
                                    enrich your rituals. Bagyalakshmi is here to support your spiritual needs with care
                                    and dedication.</p> 
                                </div>
                              
                                <div>
                                    <a href="" class="view-detail">Explore</a>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-lg-6  order-2">
                        <div class="additional-section-main">
                            <img class="img-fluid " src="./assets/images/additional-section/additional-section-2.png"
                                alt="">
                        </div>
                    </div>

                </div>

            </div>
        </section>

        <!-- Testimonials -->
        <section class="testimonial-area">
            <div class="gtco-testimonials">
                <div class="section-heading">
                    <div class="d-flex justify-content-center align-items-center">
                        <span> <img class="heading-icon" src="./assets/images/icon/heading-icon.png" alt="" srcset="">
                        </span>
                        <h3> Testimonials</h3>
                    </div>
                </div>
                <div class="owl-carousel owl-carousel1 owl-theme">
                    <div>
                        <div class="card text-center">
                            <div class="card-body">


                                <p class="card-text">"Bagyalakshmi offers the finest devotion items I’ve ever used. The
                                    camphor lights up instantly and lasts longer than any other brand I’ve tried. Their
                                    kumkum is pure and perfect for all my rituals. I highly recommend Bagyalakshmi to
                                    anyone looking for authentic and high-quality devotional products."</p>
                                <span> — Arun P., Coimbatore </span>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="card text-center">
                            <div class="card-body">


                                <p class="card-text">"The quality of Bagyalakshmi’s products is unmatched. The camphor
                                    burns with a bright flame, and the kumkum is so rich in color. It’s clear that a lot
                                    of care goes into making these products. I feel a deeper connection in my prayers
                                    thanks to Bagyalakshmi." </p>
                                <span> — Meera N., Mumbai </span>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="card text-center">
                            <div class="card-body">


                                <p class="card-text"> "I’ve been purchasing devotion items from Bagyalakshmi for months
                                    now, and I couldn’t be happier. The products are always of excellent quality, and
                                    the service is top-notch. The camphor and kumkum are essential for my daily prayers,
                                    and I trust Bagyalakshmi to provide the best." </p>
                                <span> — Lakshmi G., Bangalore </span>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="card text-center">
                            <div class="card-body">


                                <p class="card-text">"I was introduced to Bagyalakshmi by a friend, and I’m so grateful!
                                    The devotion items are incredibly pure, and you can feel the difference in your
                                    spiritual practices. The customer service is also very responsive and helpful.
                                    Bagyalakshmi has earned a lifelong customer in me."</p>
                                <span> Veera k., Chennai </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>



    </main><!-- End #main -->


    <!-- Footer -->
    <?php include("footer.php") ?>
    <!-- End Footer -->
    <a href="#" class="scroll-top d-flex align-items-center justify-content-center"><i
            class="bi bi-arrow-up-short"></i></a>

    <!-- Vendor JS Files -->
    <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
    <script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
    <script src="assets/vendor/aos/aos.js"></script>
    <script src="assets/vendor/php-email-form/validate.js"></script>

    <!-- Template Main JS File -->
    <script src="assets/js/main.js"></script>
    <!-- Include jQuery and Owl Carousel JavaScript -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    <script async>
    $(document).ready(function() {
        $(".owl-carousel").owlCarousel({
            loop: true,
            dots: false,
            margin: 10,
            responsiveClass: true,
            responsive: {
                0: {
                    items: 1,
                    nav: true
                },
                425: {
                    items: 2,
                    nav: true
                },
                600: {
                    items: 3,
                    nav: false
                },
                1000: {
                    items: 5,
                    nav: true,
                    loop: false
                }
            }
        });
    });

    $(".testimonial-content").owlCarousel({
        loop: true,
        dots: false,
        margin: 10,
        dots: true,
        nav: false,
        mouseDrag: true,
        autoplay: true,
        autoplayTimeout: 4000,
        smartSpeed: 800,
        responsive: {
            0: {
                items: 1,

            },
            425: {
                items: 2,
            },
            600: {
                items: 2,

            },
        }

    });

    var carousels = function() {
        $(".owl-carousel1").owlCarousel({
            loop: true,
            center: true,
            margin: 0,
            responsiveClass: true,
            nav: false,
            responsive: {
                0: {
                    items: 1,
                    nav: false
                },
                680: {
                    items: 2,
                    nav: false,
                    loop: false
                },
                1000: {
                    items: 3,
                    nav: true
                }
            }
        });
    };

    (function($) {
        carousels();
    })(jQuery);
    </script>

    <script async>
    $('.owl-carousel-best-sellar').owlCarousel({
        loop: true,
        margin: 10,
        nav: true,
        responsive: {
            0: {
                items: 2
            },
            600: {
                items: 2
            },
            1000: {
                items: 4
            }
        }
    })
    </script>
    <script defer >
    $(document).ready(function() {
        $('.slick-slider').slick({
            dots: true, // Enable dots navigation
            arrows: true, // Enable arrows navigation
            prevArrow: '<button type="button" class="slick-prev">Previous</button>',
            nextArrow: '<button type="button" class="slick-next">Next</button>',
        });
    });
    </script>
    <!-- jQuery (required for Slick) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

    <!-- Slick JavaScript -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js"></script>
    <script async>
    $(document).ready(function() {
        $('.unique-slick-slider').slick({
            dots: false,
            arrows: true,
            infinite: true,
            speed: 500,
            prevArrow: '<button type="button" class="slick-prev">Previous</button>',
            nextArrow: '<button type="button" class="slick-next">Next</button>',
            responsive: [{
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 3,

                    },
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 3,

                    },
                },
            ]

        });
    });
    </script>
</body>

</html>